USE [master]
GO
/****** Object:  Database [GENISIS_DB]    Script Date: 5/23/2017 3:08:08 PM ******/

--CREATE GENISIS_DB (MAKE SURE YOU CHANGE THE LOCATION OF THE DATA AND LOG FILES BEFORE RUNNING THE SCRIPT--

CREATE DATABASE [GENISIS_DB]
 CONTAINMENT = NONE
 ON  PRIMARY 
( NAME = N'GENISIS_DB', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL11.MSSQLSERVER2012\MSSQL\DATA\GENISIS_DB.mdf' , SIZE = 3072KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'GENISIS_DB_log', FILENAME = N'C:\Program Files\Microsoft SQL Server\MSSQL11.MSSQLSERVER2012\MSSQL\DATA\GENISIS_DB_log.ldf' , SIZE = 3840KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO
ALTER DATABASE [GENISIS_DB] SET COMPATIBILITY_LEVEL = 110
GO
IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [GENISIS_DB].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_NULL_DEFAULT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_NULLS OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_PADDING OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ANSI_WARNINGS OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ARITHABORT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_CLOSE OFF 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_CREATE_STATISTICS ON 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_SHRINK OFF 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_UPDATE_STATISTICS ON 
GO
ALTER DATABASE [GENISIS_DB] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET CURSOR_DEFAULT  GLOBAL 
GO
ALTER DATABASE [GENISIS_DB] SET CONCAT_NULL_YIELDS_NULL OFF 
GO
ALTER DATABASE [GENISIS_DB] SET NUMERIC_ROUNDABORT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET QUOTED_IDENTIFIER OFF 
GO
ALTER DATABASE [GENISIS_DB] SET RECURSIVE_TRIGGERS OFF 
GO
ALTER DATABASE [GENISIS_DB] SET  DISABLE_BROKER 
GO
ALTER DATABASE [GENISIS_DB] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO
ALTER DATABASE [GENISIS_DB] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO
ALTER DATABASE [GENISIS_DB] SET TRUSTWORTHY OFF 
GO
ALTER DATABASE [GENISIS_DB] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO
ALTER DATABASE [GENISIS_DB] SET PARAMETERIZATION SIMPLE 
GO
ALTER DATABASE [GENISIS_DB] SET READ_COMMITTED_SNAPSHOT OFF 
GO
ALTER DATABASE [GENISIS_DB] SET HONOR_BROKER_PRIORITY OFF 
GO
ALTER DATABASE [GENISIS_DB] SET RECOVERY FULL 
GO
ALTER DATABASE [GENISIS_DB] SET  MULTI_USER 
GO
ALTER DATABASE [GENISIS_DB] SET PAGE_VERIFY CHECKSUM  
GO
ALTER DATABASE [GENISIS_DB] SET DB_CHAINING OFF 
GO
ALTER DATABASE [GENISIS_DB] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF ) 
GO
ALTER DATABASE [GENISIS_DB] SET TARGET_RECOVERY_TIME = 0 SECONDS 
GO
EXEC sys.sp_db_vardecimal_storage_format N'GENISIS_DB', N'ON'
GO

--CREATE APP USER FOR GENISIS_DB--

CREATE LOGIN [genisis]
    WITH PASSWORD = N'admin123';

GO
CREATE USER [genisis] FOR LOGIN [genisis];

GO
GRANT CONNECT TO [genisis]
    AS [dbo];
	 
EXEC sp_addrolemember N'db_datareader', N'genisis'

EXEC sp_addrolemember N'db_datawriter', N'genisis'

--CREATE SEQUENCE FOR User_id GENERATION--

CREATE SEQUENCE [dbo].[User_Id_Seq] 
 AS [int]
 START WITH 1
 INCREMENT BY 1
 MINVALUE 1
 MAXVALUE 500
 CYCLE 
 CACHE 
 GO

--CREATE TABLES FOR GENISIS_DB--
****** Object:  Table [dbo].[CommentHistory]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[CommentHistory](
	[CommentId] [int] NOT NULL,
	[RequestId] [int] NOT NULL,
	[StatusId] [int] NOT NULL,
	[Comments] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[TYPE] [varchar](6) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_CommentHistory] PRIMARY KEY CLUSTERED 
(
	[CommentId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Management_table]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Management_table](
	[ReqID] [int] NULL,
	[DatabaseName] [varchar](50) NULL,
	[CopyStatus] [varchar](25) NULL,
	[dateandtime] [datetime] NULL,
	[checksum_before_copy] [bigint] NULL,
	[checksum_after_copy] [bigint] NULL,
	[Source_Schema] [varchar](50) NULL,
	[Destination_Schema] [varchar](50) NULL,
	[Table_Name] [varchar](50) NULL,
	[rowcount_before_copy] [int] NULL,
	[rowcount_after_copy] [int] NULL,
	[status_before_copy] [varchar](20) NULL,
	[status_after_copy] [varchar](20) NULL
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Request]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Request](
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestTypeId] [int] NOT NULL,
	[SourceId] [int] NOT NULL,
	[StudyApprovalId] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_Request] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[RequestHistory]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[RequestHistory](
	[HistLineNo] [int] NOT NULL,
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[Title] [varchar](256) NULL,
	[Description] [varchar](3000) NULL,
	[StatusDescription] [varchar](50) NULL,
	[RequestTypeId] [int] NOT NULL,
	[SourceId] [int] NOT NULL,
	[StudyApprovalId] [int] NOT NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
	[ApproverId] [varchar](50) NULL,
	[TaskId] [varchar](50) NULL,
 CONSTRAINT [PK_RequestHistory] PRIMARY KEY CLUSTERED 
(
	[HistLineNo] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[RequestType]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[RequestType](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_RequestType] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Role_Type]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Role_Type](
	[Role_Type_id] [int] NOT NULL,
	[Role_Name] [varchar](50) NOT NULL,
	[Role_Description] [varchar](50) NOT NULL,
 CONSTRAINT [Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Role_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Source]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Source](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_Source] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[StudyApproval]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[StudyApproval](
	[Id] [int] NOT NULL,
	[ProcessId] [int] NOT NULL,
	[ApprovalIdObtained] [varchar](3000) NULL,
	[AssociatedStudyApproval1] [int] NULL,
	[AssociatedStudyApproval2] [int] NULL,
	[AssociatedStudyApproval3] [int] NULL,
	[Title] [varchar](50) NULL,
	[Description] [varchar](3000) NULL,
	[CreatedOn] [datetime] NULL,
	[ModifiedOn] [datetime] NULL,
	[CreatedBy] [varchar](50) NULL,
	[ModifiedBy] [varchar](50) NULL,
 CONSTRAINT [PK_StudyApproval] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[User_Approver]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[User_Approver](
	[Id] [int] NOT NULL,
	[User_id] [int] NOT NULL,
	[User_Approver_id] [int] NOT NULL,
 CONSTRAINT [User_Approver_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[User_Role_Type]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[User_Role_Type](
	[Id] [int] NOT NULL,
	[Role_Type_id] [int] NOT NULL,
	[User_Type_id] [int] NOT NULL,
	[User_id] [int] NOT NULL,
	[Start_Date] [datetime] NOT NULL,
	[End_Date] [datetime] NULL,
 CONSTRAINT [User_Role_Type_pk] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
/****** Object:  Table [dbo].[User_Type]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[User_Type](
	[User_Type_id] [int] NOT NULL,
	[User_Type_desc] [varchar](50) NOT NULL,
 CONSTRAINT [User_Type_pk] PRIMARY KEY CLUSTERED 
(
	[User_Type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[Users]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[Users](
	[User_id] [int] NOT NULL,
	[First_Name] [varchar](50) NOT NULL,
	[Middle_Name] [varchar](50) NULL,
	[Last_Name] [varchar](50) NOT NULL,
	[Last_Name2] [varchar](50) NULL,
	[Create_Date] [datetime] NOT NULL,
	[Email_id] [varchar](320) NOT NULL,
	[User_Active] [tinyint] NOT NULL,
	[Active_date] [datetime] NOT NULL,
	[Inactive_date] [datetime] NULL,
 CONSTRAINT [User_pk] PRIMARY KEY CLUSTERED 
(
	[User_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY],
 CONSTRAINT [UC_Email_id] UNIQUE NONCLUSTERED 
(
	[Email_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO
/****** Object:  Table [dbo].[WorkflowStatus]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[WorkflowStatus](
	[Id] [int] NOT NULL,
	[Description] [varchar](50) NULL,
 CONSTRAINT [PK_WorkflowStatus] PRIMARY KEY CLUSTERED 
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF
GO


--CREATE FOREIGN KEY CONSTRAINTS FOR THE TABLES--


ALTER TABLE [dbo].[CommentHistory]  WITH CHECK ADD  CONSTRAINT [FK_CommentHistory_Request] FOREIGN KEY([RequestId])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[CommentHistory] CHECK CONSTRAINT [FK_CommentHistory_Request]
GO
ALTER TABLE [dbo].[CommentHistory]  WITH CHECK ADD  CONSTRAINT [FK_CommentHistory_WorkflowStatus] FOREIGN KEY([StatusId])
REFERENCES [dbo].[WorkflowStatus] ([Id])
GO
ALTER TABLE [dbo].[CommentHistory] CHECK CONSTRAINT [FK_CommentHistory_WorkflowStatus]
GO
ALTER TABLE [dbo].[Request]  WITH CHECK ADD  CONSTRAINT [Fk_RqId] FOREIGN KEY([RequestTypeId])
REFERENCES [dbo].[RequestType] ([Id])
GO
ALTER TABLE [dbo].[Request] CHECK CONSTRAINT [Fk_RqId]
GO
ALTER TABLE [dbo].[Request]  WITH CHECK ADD  CONSTRAINT [FK_sourceid] FOREIGN KEY([SourceId])
REFERENCES [dbo].[Source] ([Id])
GO
ALTER TABLE [dbo].[Request] CHECK CONSTRAINT [FK_sourceid]
GO
ALTER TABLE [dbo].[Request]  WITH CHECK ADD  CONSTRAINT [StudyApproval_id] FOREIGN KEY([StudyApprovalId])
REFERENCES [dbo].[StudyApproval] ([Id])
GO
ALTER TABLE [dbo].[Request] CHECK CONSTRAINT [StudyApproval_id]
GO
ALTER TABLE [dbo].[RequestHistory]  WITH CHECK ADD  CONSTRAINT [FK_RequestHistory_Request] FOREIGN KEY([Id])
REFERENCES [dbo].[Request] ([Id])
GO
ALTER TABLE [dbo].[RequestHistory] CHECK CONSTRAINT [FK_RequestHistory_Request]
GO
ALTER TABLE [dbo].[RequestHistory]  WITH CHECK ADD  CONSTRAINT [FK_Requestid] FOREIGN KEY([RequestTypeId])
REFERENCES [dbo].[RequestType] ([Id])
GO
ALTER TABLE [dbo].[RequestHistory] CHECK CONSTRAINT [FK_Requestid]
GO
ALTER TABLE [dbo].[RequestHistory]  WITH CHECK ADD  CONSTRAINT [FK_SourcId] FOREIGN KEY([SourceId])
REFERENCES [dbo].[Source] ([Id])
GO
ALTER TABLE [dbo].[RequestHistory] CHECK CONSTRAINT [FK_SourcId]
GO
ALTER TABLE [dbo].[RequestHistory]  WITH CHECK ADD  CONSTRAINT [FK_StudyAppid] FOREIGN KEY([StudyApprovalId])
REFERENCES [dbo].[StudyApproval] ([Id])
GO
ALTER TABLE [dbo].[RequestHistory] CHECK CONSTRAINT [FK_StudyAppid]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User] FOREIGN KEY([User_Approver_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User]
GO
ALTER TABLE [dbo].[User_Approver]  WITH CHECK ADD  CONSTRAINT [User_Approver_User_id] FOREIGN KEY([User_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Approver] CHECK CONSTRAINT [User_Approver_User_id]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_Type_User] FOREIGN KEY([User_id])
REFERENCES [dbo].[Users] ([User_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_Type_User]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [FK_User_typeID] FOREIGN KEY([User_Type_id])
REFERENCES [dbo].[User_Type] ([User_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [FK_User_typeID]
GO
ALTER TABLE [dbo].[User_Role_Type]  WITH CHECK ADD  CONSTRAINT [User_Role_Type_Role_Type] FOREIGN KEY([Role_Type_id])
REFERENCES [dbo].[Role_Type] ([Role_Type_id])
GO
ALTER TABLE [dbo].[User_Role_Type] CHECK CONSTRAINT [User_Role_Type_Role_Type]
GO

USE [master]
GO
ALTER DATABASE [GENISIS_DB] SET  READ_WRITE 
GO


--DATA LOAD FOR THE LOOKUP TABLES--

USE [GENISIS_DB]
GO
INSERT [dbo].[RequestType] ([Id], [Description]) VALUES (1, N'Aggregate')
GO
INSERT [dbo].[RequestType] ([Id], [Description]) VALUES (2, N'DetailRecords')
GO
INSERT [dbo].[Role_Type] ([Role_Type_id], [Role_Name], [Role_Description]) VALUES (1, N'Administrator', N'Administrator')
GO
INSERT [dbo].[Role_Type] ([Role_Type_id], [Role_Name], [Role_Description]) VALUES (2, N'requester', N'Researcher')
GO
INSERT [dbo].[Role_Type] ([Role_Type_id], [Role_Name], [Role_Description]) VALUES (3, N'dataDestinationManager', N'Data Destination Manager')
GO
INSERT [dbo].[Role_Type] ([Role_Type_id], [Role_Name], [Role_Description]) VALUES (4, N'dataSourceManager', N'Data Source Manager')
GO
INSERT [dbo].[Source] ([Id], [Description]) VALUES (1, N'Survey')
GO
INSERT [dbo].[Source] ([Id], [Description]) VALUES (2, N'Genomic')
GO
INSERT [dbo].[Source] ([Id], [Description]) VALUES (3, N' Clinical Data')
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (176, 0, NULL, NULL, NULL, NULL, N'csp572', N'csp572', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (177, 0, NULL, NULL, NULL, NULL, N'mvp001', N'mvp001', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (178, 0, NULL, NULL, NULL, NULL, N'mvp002', N'mvp002', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (179, 0, NULL, NULL, NULL, NULL, N'mvp003', N'mvp003', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (180, 0, NULL, NULL, NULL, NULL, N'mvp004', N'mvp004', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (181, 0, NULL, NULL, NULL, NULL, N'mvp005', N'mvp005', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[StudyApproval] ([Id], [ProcessId], [ApprovalIdObtained], [AssociatedStudyApproval1], [AssociatedStudyApproval2], [AssociatedStudyApproval3], [Title], [Description], [CreatedOn], [ModifiedOn], [CreatedBy], [ModifiedBy]) VALUES (182, 0, NULL, NULL, NULL, NULL, N'csp575b', N'csp575b', NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[User_Type] ([User_Type_id], [User_Type_desc]) VALUES (1, N'Contractor')
GO
INSERT [dbo].[User_Type] ([User_Type_id], [User_Type_desc]) VALUES (2, N'Employee')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (1, N'Draft')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (2, N'Submitted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (3, N'Denied')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (4, N'Returned')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (5, N'Sent')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (6, N'Update')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (7, N'RequestAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (8, N'RequestNotAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (9, N'ResultsAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (10, N'ResultsNotAccepted')
GO
INSERT [dbo].[WorkflowStatus] ([Id], [Description]) VALUES (11, N'ResultsDelivered')
GO

/****** Object:  StoredProcedure [dbo].[usp_Users_info]    Script Date: 6/9/2017 10:05:46 AM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROC [dbo].[usp_Users_info]
AS
WITH email_CTE (user_id,user_Email_id,User_Approver_id,First_Name,Last_Name,Role_Name,Role_Description,User_Type_Desc)  
AS  
(  
select us.user_id, us.email_id as user_email_id, ua.User_Approver_id,us.First_Name, us.last_name,rt.Role_name, rt.Role_Description, ut.User_Type_desc
 from user_approver ua
   right outer join users us
  on ua.user_id = us.user_id
  join User_Role_Type AS ur
on us.User_id  = ur.User_id
join Role_Type rt
ON rt.Role_Type_id = ur.Role_Type_id
JOIN
User_Type as ut
ON
ut.User_Type_id = ur.User_Type_id
   
)



SELECT temp.user_id,temp.user_email_id,temp.First_Name, temp.Last_Name, temp.User_Approver_id, us.Email_id as user_approver_email_id, 
temp.Role_name, temp.Role_Description, temp.User_Type_desc
FROM email_CTE temp
left outer join users us
on temp.User_Approver_id = us.User_id
join User_Role_Type AS ur
on temp.User_id  = ur.User_id
join Role_Type rt
ON rt.Role_Type_id = ur.Role_Type_id
JOIN
User_Type as ut
ON
ut.User_Type_id = ur.User_Type_id
order by user_id
OPTION (HASH JOIN)

GO
